/*
Risodukore.
Risolutore di Sudoku.
Versione 1.0F
Copyright (C) Daniele Rampoldi

This program is free software: you can redistribute it and/or modify it under the terms
 of the GNU General Public License, version 3, as published by the Free Software Foundation.
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.
You should have received a copy of the GNU General Public License version 3 along with this program.
If not, see http://www.gnu.org/licenses/ .

Daniele Rampoldi
www.zxdr.it
rampoldid@zxdr.it
rampoldid@yahoo.it
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>


int *prendiriga(int *p,int i,int **tabella);
int **inserisci(int **tabella,int i,int j);
int *prendicolonna(int *p,int j,int **tabella);
int *prendiquadrato(int *p,int i,int j,int **tabella);
void stampatabella(int **tabella,int **passi);
int ***inizializza(int grandezza,int ***ntab,int **tabella);
int **univoci(int grandezza,int ***ntab,int **tabella,int **canc);
void stampapercorso(int **tabella,int **passi);


FILE *file;
int grandezza=0;
int a=0,b=0,c;
int **tabella;
int **tabellaold;	/* serve solo per la stampa finale */
int t2[100];
clock_t tp0,tp1;
int primozero=0;
int ***ntab;
int **passi;		/* praticamente passi[a][b] sara' la "posizione in classifica"
						+ 10000 (), dell'elemento tabella[a][b] */
/*
10059 --> 59 punto trovato IMPOSTO ARBITRARIAMENTE (10000)
46    --> 46 punto trovato DETERMINATO UNIVOCAMENTE
*/
int classifica;		/* con che ordine ho trovato i vari punti  */
char fileinput[255];




int main(int argc,char *argv[])
{
strcpy(fileinput,"in.txt");
for(b=1;b<argc;b++)
	{if(strcmp(argv[b],"-i")==0)		/* conninfo */
	 	{b++;
	 	 strcpy(fileinput,argv[b]);
	 	 break;		/* come parametri voglio solo : Risodukore -i input.txt */
		}
	}

file=fopen(fileinput,"r");
if(file==NULL)
	{fprintf(stderr,"Errore nell'apertura del file %s\n",fileinput);
	 return 0;
	}

c=fgetc(file);
/* dalla prima riga tiro fuori anche la grandezza della tabella */
while(c!='\n')
	{grandezza++;
	 if(c=='0')
		{t2[a]=0;
		 c=fgetc(file);
		}
	 else
		{t2[a]=c-48;
		 c=fgetc(file);
		 while(c!=' ' && c!='\n')
		 	{t2[a]=(t2[a]*10)+(c-48);
		 	 c=fgetc(file);
			}
		}
	 a++;
	 while(c==' ')
	 	c=fgetc(file);
	}

tabella=(int **)calloc(grandezza,sizeof(int *));
for(b=0;b<grandezza;b++)
	tabella[b]=(int *)calloc(grandezza,sizeof(int));

tabellaold=(int **)calloc(grandezza,sizeof(int *));
for(b=0;b<grandezza;b++)
	tabellaold[b]=(int *)calloc(grandezza,sizeof(int));

/* NUOVA AGGIUNTA */
classifica=0;
passi=(int **)calloc(grandezza,sizeof(int *));
for(b=0;b<grandezza;b++)
	passi[b]=(int *)calloc(grandezza,sizeof(int));
for(a=0;a<grandezza;a++)
	{for(b=0;b<grandezza;b++)
		{passi[a][b]=0;
		}
	}


for(b=0;b<grandezza;b++)
	tabellaold[0][b]=tabella[0][b]=t2[b];
a=1;
b=0;
c=fgetc(file);
while(c!=EOF)
	{while(c!='\n')
		{if(c=='0')
			{tabellaold[a][b]=tabella[a][b]=0;
			 c=fgetc(file);
			}
		 else
			{tabellaold[a][b]=tabella[a][b]=c-48;
			 c=fgetc(file);
			 while(c!=' ' && c!='\n')
			 	{tabellaold[a][b]=tabella[a][b]=(tabella[a][b]*10)+(c-48);
			 	 c=fgetc(file);
				}
			}
		 b++;
		 while(c==' ')
	 		c=fgetc(file);
		}
	 a++;
	 b=0;
	 c=fgetc(file);
	}

fclose(file);
/* ora ho la tabella */

fprintf(stderr,"\nTabella iniziale:\n\n");
for(a=0;a<grandezza;a++)
	{for(b=0;b<grandezza;b++)
		{fprintf(stderr,"%2d ",tabella[a][b]);
		}
	 fprintf(stderr,"\n");
	}
fprintf(stderr,"\n");

tp0=clock();

tabella=inserisci(tabella,0,0);

return 1;
}









int **inserisci(int **tabella,int i,int j)
{
int *possibili;
int ii;
int **cancella;
int s,ss;

cancella=(int **)calloc(2,sizeof(int *));
cancella[0]=(int *)calloc(1000,sizeof(int));
cancella[1]=(int *)calloc(1000,sizeof(int));

ntab=inizializza(grandezza,ntab,tabella);
cancella=univoci(grandezza,ntab,tabella,cancella);
/* cancella ha le coordinate dei punti modificati e termina con un (-1,-1) */

for(s=0;s<grandezza;s++)
	{for(ss=0;ss<grandezza;ss++)
	 	{free(ntab[s][ss]);
		}
	 free(ntab[s]);
	}
free(ntab);


possibili=(int *)calloc(grandezza,sizeof(int));
for(ii=0;ii<grandezza;ii++)
	possibili[ii]=ii+1;

while(tabella[i][j]!=0)		/* scorro la tabella */
	{j++;
	 if(j>=grandezza)
	 	{i++;
	 	 if(i>=grandezza)
	 	 	{tp1=clock();
			 stampatabella(tabella,passi);
			 fprintf(stderr,"\n\nEsecuzione terminata.");
			 fprintf(stderr,"\nPremere un tasto per chiudere questa finestra.\n");
			 getchar();
			 exit(1);
			}
		 else
			j=0;
		}
	}

/* sono arrivato al primo '0' */
/* ora estraggo i possibili valori --> 1,...,9 sulla riga,sulla colonna e nel quadratino */

possibili=prendiriga(possibili,i,tabella);
possibili=prendicolonna(possibili,j,tabella);
possibili=prendiquadrato(possibili,i,j,tabella);

//for(ii=0;ii<grandezza;ii++)
for(ii=grandezza-1;ii>=0;ii--)
	{if(possibili[ii]==0)
		continue;
	 tabella[i][j]=possibili[ii];
	 classifica++;
	 passi[i][j]=classifica+10000;
	 if(primozero==0)
	 	fprintf(stderr,"Sottoramo Principale %d\n",possibili[ii]);
	 primozero++;
	 tabella=inserisci(tabella,i,j);
	 classifica--;
	 primozero--;
	}

tabella[i][j]=0;

s=0;
while(cancella[0][s]!=-1)
	{tabella[cancella[0][s]][cancella[1][s]]=0;
	 classifica--;
	 s++;
	}

free(cancella[0]);
free(cancella[1]);
free(cancella);
free(possibili);

return tabella;
}








int *prendiriga(int *p,int i,int **tabella)
{
int j;

for(j=0;j<grandezza;j++)
	{if(tabella[i][j]==0)
		continue;
	 else
		p[tabella[i][j]-1]=0;
	}

return p;
}







int *prendicolonna(int *p,int j,int **tabella)
{
int i;

for(i=0;i<grandezza;i++)
	{if(tabella[i][j]==0)
		continue;
	 else
		p[tabella[i][j]-1]=0;
	}

return p;
}







int *prendiquadrato(int *p,int i,int j,int **tabella)
{
int g,h;
int minriga,maxriga,mincol,maxcol;

g=(int)sqrt((float)grandezza);

/* ora stabilisco i limiti del quadrato */
h=i;
while(h%g!=0)
	h--;
minriga=h;

h=i+1;
while(h%g!=0)
	h++;
maxriga=h;

h=j;
while(h%g!=0)
	h--;
mincol=h;

h=j+1;
while(h%g!=0)
	h++;
maxcol=h;

/* ora tolgo i numeri */
for(i=minriga;i<maxriga;i++)
	{for(j=mincol;j<maxcol;j++)
		{if(tabella[i][j]==0)
			continue;
		 else
			p[tabella[i][j]-1]=0;
		}
	}

return p;
}







void stampatabella(int **tabella,int **passi)
{
int i,j;
int colrcorr,colccorr,quad;
	/* colore corrente di riga, di colonna e grandezza dei singoli quadratini */

file=fopen("out.html","w");
if(file==NULL)
	{fprintf(stderr,"Errore nell'apertura del file out.html\n");
	 return;
	}

fprintf(file,"<html>\n<head>\n<META NAME=\"DC.Title\" CONTENT=\"Sudoku\">");
fprintf(file,"\n<META NAME=\"description\" CONTENT=\"Output del programma");
fprintf(file," per la risoluzione del Sudoku di Daniele Rampoldi\">\n");
fprintf(file,"<META NAME=\"keywords\" CONTENT=\"sudoku,daniele rampoldi\">");
fprintf(file,"\n\n<title>Sudoku</title>\n\n</head><body>\n\n");

fprintf(file,"<body bgcolor=\"#006600\" text=black link=\"#000000\" vlink=\"#000000\" alink=\"#0000aa\">");
fprintf(file,"\n<br><br>\n<h1 align=\"center\">Soluzione Sudoku</h1>\n<br>\n\n");
fprintf(file,"<TABLE border=1 cellpadding=5 align=center>\n\n");

quad=(int)sqrt((float)grandezza);
colrcorr=-1;
for(i=0;i<grandezza;i++)
	{if(i%quad==0)
		colrcorr=(colrcorr+1)%2;
	 colccorr=colrcorr;
	 fprintf(file,"<tr>");
	 for(j=0;j<grandezza;j++)
		{if(j%quad==0)
			colccorr=(colccorr+1)%2;
		 if(tabellaold[i][j]==tabella[i][j])
			if(colccorr==0)
				fprintf(file,"<td align=center>%d</td> ",tabella[i][j]);
			else
				fprintf(file,"<td align=center bgcolor=\"#007700\">%d</td> ",tabella[i][j]);
		 else
		 	if(colccorr==0)
				fprintf(file,"<td align=center><font color=red>%d</font></td> ",tabella[i][j]);
			else
				fprintf(file,"<td align=center bgcolor=\"#007700\"><font color=red>%d</font></td> ",tabella[i][j]);
		}
	 fprintf(file,"</tr>\n");
	}
fprintf(file,"</table><br><br>");

fprintf(file,"\nGrandezza tabella: %d x %d<br>\n",grandezza,grandezza);
fprintf(file,"Tempo della CPU impiegato: %7.3lf secondi<br>\n",(tp1-tp0)/(double)CLOCKS_PER_SEC);
fprintf(file,"<a href=\"out4F.html\">Guarda la soluzione passo per passo</a><br>\n");
fprintf(file,"</body></html>\n");

fclose(file);
stampapercorso(tabella,passi);

system("start out.html");
}









int ***inizializza(int grandezza,int ***ntab,int **tabella)
{
int s,ss,sss,s4,h,g;
int minriga,maxriga,mincol,maxcol;

g=(int)sqrt((float)grandezza);
ntab=(int ***)calloc(grandezza,sizeof(int **));

for(s=0;s<grandezza;s++)
	{ntab[s]=(int **)calloc(grandezza,sizeof(int *));
	 for(ss=0;ss<grandezza;ss++)
	 	{ntab[s][ss]=(int *)calloc(grandezza,sizeof(int));
		}
	}
/* ora ho ntab[n][i][j], con n,i,j che vanno da 0 a "grandezza" */

/*
Seconda parte:
	prima devo mettere a 1 tutti gli elementi delle n tabelle i x j
	poi scandisco la matrice e metto 0 se l'elemento della matrice non puo' assumere un certo valore
*/

for(s=0;s<grandezza;s++)
	{for(ss=0;ss<grandezza;ss++)
		{for(sss=0;sss<grandezza;sss++)
			{if(tabella[ss][sss]!=0)
				ntab[s][ss][sss]=0;
			 else
			 	ntab[s][ss][sss]=1;
			}
		}
	}

for(s=0;s<grandezza;s++)
	{for(ss=0;ss<grandezza;ss++)
		{if(tabella[s][ss]==0)
			continue;
		 else
		 	{/* tolgo la riga */
		 	 for(sss=0;sss<grandezza;sss++)
			 	 ntab[tabella[s][ss]-1][s][sss]=0;
			 /* tolgo la colonna */
		 	 for(sss=0;sss<grandezza;sss++)
			 	 ntab[tabella[s][ss]-1][sss][ss]=0;
			 /* tolgo il quadrato */
			 /* ora stabilisco i limiti del quadrato */
			 h=s;	/* riga */
			 while(h%g!=0)
			 	h--;
			 minriga=h;

			 h=s+1;
			 while(h%g!=0)
			 	h++;
			 maxriga=h;

			 h=ss;	/* colonna */
			 while(h%g!=0)
			 	h--;
			 mincol=h;

			 h=ss+1;
			 while(h%g!=0)
			 	h++;
			 maxcol=h;

			 /* ora tolgo i numeri */
			 for(sss=minriga;sss<maxriga;sss++)
			 	{for(s4=mincol;s4<maxcol;s4++)
			 		{ntab[tabella[s][ss]-1][sss][s4]=0;
			 		}
			 	}
			}	/* fine else */
		}	/* fine for(ss=0;ss<grandezza;ss++) */
	}	/* fine for(s=0;s<grandezza;s++) */

return ntab;
}









int **univoci(int grandezza,int ***ntab,int **tabella,int **canc)
{
int giro=1,i,j,n,k,g,kk,inseriti=0;
int minriga,maxriga,mincol,maxcol;
/* ULTIMA AGGIUNTA */
int rrr;

/*
per ogni tabella in ntab devo vedere se devo inserire UNIVOCAMENTE (senza alternativa)
un qualche numero.
naturalmente continuo finche' faccio un giro a vuoto
*/

g=(int)sqrt((float)grandezza);

while(giro>0)
	{giro=0;
	 for(n=0;n<grandezza;n++)
	 	{for(i=0;i<grandezza;i++)
	 		{for(j=0;j<grandezza;j++)
	 			{if(ntab[n][i][j]==0)
	 				continue;
	 			 else
	 			 	{


	/* determino la matricetta */
	k=i;	/* riga */
	while(k%g!=0)
		k--;
	minriga=k;

	k=i+1;
	while(k%g!=0)
		k++;
	maxriga=k;

	k=j;	/* colonna */
	while(k%g!=0)
		k--;
	mincol=k;

	k=j+1;
	while(k%g!=0)
		k++;
	maxcol=k;

	/* controllo se e' l'unico della riga */
	for(k=0;k<grandezza;k++)
	 	{if(k==j)	/* corrente */
	 		continue;
	 	 if(ntab[n][i][k]!=0)
	 	 	break;
		}
	if(k==grandezza)	/* e' l'unico della riga */
		{giro++;
		 for(k=0;k<grandezza;k++)
		 	ntab[k][i][j]=0;
		 tabella[i][j]=n+1;
		 classifica++;
		 passi[i][j]=classifica+20000;
		 canc[0][inseriti]=i;
		 canc[1][inseriti]=j;
		 inseriti++;
		 /* modifico la colonna e la matricetta */
		 for(k=0;k<grandezza;k++)
		 	ntab[n][k][j]=0;
		 for(k=minriga;k<maxriga;k++)
			{for(kk=mincol;kk<maxcol;kk++)
				ntab[n][k][kk]=0;
			}
		 continue;
		}


	/* controllo se e' l'unico della colonna */
	for(k=0;k<grandezza;k++)
	 	{if(k==i)	/* corrente */
	 		continue;
	 	 if(ntab[n][k][j]!=0)
	 	 	break;
		}
	if(k==grandezza)	/* e' l'unico della colonna */
		{giro++;
		 for(k=0;k<grandezza;k++)
		 	ntab[k][i][j]=0;
		 tabella[i][j]=n+1;
		 classifica++;
		 passi[i][j]=classifica+30000;
		 canc[0][inseriti]=i;
		 canc[1][inseriti]=j;
		 inseriti++;
		 /* modifico la riga e la matricetta */
		 for(k=0;k<grandezza;k++)
		 	ntab[n][i][k]=0;
		 for(k=minriga;k<maxriga;k++)
			{for(kk=mincol;kk<maxcol;kk++)
				ntab[n][k][kk]=0;
			}
		 continue;
		}


	/* controllo se e' l'unico della matricetta */
	for(k=minriga;k<maxriga;k++)
			{for(kk=mincol;kk<maxcol;kk++)
				{if(k==i && kk==j)	/* corrente */
					continue;
	 			 if(ntab[n][k][kk]!=0)
	 			 	break;
				}
			 if(kk!=maxcol)	/* sono uscito col break */
			 	break;
			}
	if(k==maxriga)	/* e' l'unico della matricetta */
		{giro++;
		 for(k=0;k<grandezza;k++)
		 	ntab[k][i][j]=0;
		 tabella[i][j]=n+1;
		 classifica++;
		 passi[i][j]=classifica+40000;
		 canc[0][inseriti]=i;
		 canc[1][inseriti]=j;
		 inseriti++;
		 /* modifico la riga e la colonna */
		 for(k=0;k<grandezza;k++)
		 	ntab[n][i][k]=0;
		 for(k=0;k<grandezza;k++)
		 	ntab[n][k][j]=0;
		 continue;
		}





/*
ULTIMA AGGIUNTA:
	per ogni quadratino se ho 1 "che formano un segmento" (verticale o orizzontale)
	cancello tutti gli 1 della colonna o riga corrispondente
	*/

/* segmenti orizzontali */
rrr=-1;
	for(k=minriga;k<maxriga;k++)
			{for(kk=mincol;kk<maxcol;kk++)
				{if(ntab[n][k][kk]!=0)
	 			 	if(rrr!=-1)
						{kk=maxcol;
						 k=maxriga+2;
						}
					else
						{rrr=k;	/* riga corrente */
						 kk=maxcol;	/* esce dal for piu' interno */
						}
				}
			}

if(rrr==-1)
	fprintf(stderr,"Errore!!! (\?\?\?Non c\'e\' una soluzione\?\?\?)\n");

	if(k==maxriga)	/* c'e' un segmento orizzontale */
		{/* modifico la riga corrispondente */
		 for(k=0;k<grandezza;k++)
		 	if(k<mincol || k>=maxcol)
				{if(ntab[n][rrr][k]!=0)
					{ntab[n][rrr][k]=0;
					 giro++;
					}
				}
		 continue;
		}



/* segmenti verticali */
rrr=-1;
	for(k=mincol;k<maxcol;k++)
			{for(kk=minriga;kk<maxriga;kk++)
				{if(ntab[n][kk][k]!=0)
	 			 	if(rrr!=-1)
						{kk=maxriga;
						 k=maxcol+2;
						}
					else
						{rrr=k;	/* colonna corrente */
						 kk=maxriga;	/* esce dal for piu' interno */
						}
				}
			}

if(rrr==-1)
	fprintf(stderr,"Errore!!! (\?\?\?Non c\'e\' una soluzione\?\?\?)\n");

	if(k==maxcol)	/* c'e' un segmento verticale */
		{/* modifico la colonna corrispondente */
		 for(k=0;k<grandezza;k++)
		 	if(k<minriga || k>=maxriga)
				if(ntab[n][k][rrr]!=0)
					{ntab[n][k][rrr]=0;
					 giro++;
					}
		 continue;
		}







					}	/* fine else */
				}	/* fine for(j) */
			}	/* fine for(i) */
		}	/* fine for(n) */
	}	/* fine while(giro>0) */


canc[0][inseriti]=-1;
canc[1][inseriti]=-1;

if(primozero==0)
	{fprintf(stderr,"Numeri inseriti con la tecnica dello sliding (cancella): %d.\n\n",inseriti);
	 fprintf(stderr,"Tabella aggiornata:\n\n");
	 for(i=0;i<grandezza;i++)
		{for(j=0;j<grandezza;j++)
			{fprintf(stderr,"%2d ",tabella[i][j]);
			}
		 fprintf(stderr,"\n");
		}
	 fprintf(stderr,"\n");
	}

return canc;
}







void stampapercorso(int **tabella,int **passi)
{
FILE *file2;
int colrcorr,colccorr,quad,gg,ii,jj,aa,bb;
/*
colrcorr --> colore corrente di riga
colccorr --> colore corrente di colonna
*/

quad=(int)sqrt((float)grandezza);

file2=fopen("out4F.html","w");
if(file2==NULL)
	{fprintf(stderr,"Errore nell'apertura del file out4F.html\n");
	 return;
	}

fprintf(file2,"<html>\n<head>\n<META NAME=\"DC.Title\" CONTENT=\"Sudoku\">");
fprintf(file2,"\n<META NAME=\"description\" CONTENT=\"Output del programma");
fprintf(file2," per la risoluzione del Sudoku di Daniele Rampoldi\">\n");
fprintf(file2,"<META NAME=\"keywords\" CONTENT=\"sudoku,daniele rampoldi\">");
fprintf(file2,"\n\n<title>Sudoku</title>\n\n</head><body>\n\n");
fprintf(file2,"<body bgcolor=\"#006600\" text=black link=\"#000000\" vlink=\"#000000\" alink=\"#0000aa\">");

fprintf(file2,"<br><br><h1 align=center>Soluzione passo per passo</h1><br><p align=center>");

fprintf(file2,"<br><b>Tabella iniziale:</b><br><br>");
fprintf(file2,"<TABLE border=1 cellpadding=5 align=center>\n\n");

colrcorr=-1;
for(ii=0;ii<grandezza;ii++)
	{if(ii%quad==0)
		colrcorr=(colrcorr+1)%2;
	 colccorr=colrcorr;
	 fprintf(file2,"<tr>\n\n");
	 for(jj=0;jj<grandezza;jj++)
		{if(jj%quad==0)
			colccorr=(colccorr+1)%2;
		 if(tabellaold[ii][jj]!=0)
			if(colccorr==0)
				fprintf(file2,"<td>%d</td>",tabellaold[ii][jj]);
			else
				fprintf(file2,"<td bgcolor=white>%d</td>",tabellaold[ii][jj]);
		 else
		 	if(colccorr==0)
			 	fprintf(file2,"<td>&nbsp;</td>");
			else
				fprintf(file2,"<td bgcolor=white>&nbsp;</td>");
		}
	 fprintf(file2,"</tr>");
	}
fprintf(file2,"</table><br><br>\n\n");

for(gg=1;gg<=classifica;gg++)
	{for(ii=0;ii<grandezza;ii++)
		{for(jj=0;jj<grandezza;jj++)
			{if(passi[ii][jj]==gg)
				{fprintf(file2,"%3d numero trovato (%d,%d): %2d (Numero determinato univocamente)<br>\n",gg,ii+1,jj+1,tabella[ii][jj]);
				 tabellaold[ii][jj]=tabella[ii][jj];
				 fprintf(file2,"<TABLE border=1 cellpadding=5 align=center>\n\n");
				 colrcorr=-1;
				 for(aa=0;aa<grandezza;aa++)
				 	{if(aa%quad==0)
						colrcorr=(colrcorr+1)%2;
					 colccorr=colrcorr;
					 fprintf(file2,"<tr>\n\n");
					 for(bb=0;bb<grandezza;bb++)
				 		{if(bb%quad==0)
							colccorr=(colccorr+1)%2;
						 if(tabellaold[aa][bb]==0)
						 	if(colccorr==0)
							 	fprintf(file2,"<td>&nbsp;</td>\n");
							else
								fprintf(file2,"<td bgcolor=white>&nbsp;</td>\n");
						 else
						 	if(aa==ii && bb==jj)
						 		fprintf(file2,"<td bgcolor=red>%d</td>\n",tabellaold[aa][bb]);
						 	else
						 		if(colccorr==0)
							 		fprintf(file2,"<td>%d</td>\n",tabellaold[aa][bb]);
							 	else
							 		fprintf(file2,"<td bgcolor=white>%d</td>\n",tabellaold[aa][bb]);
						}
					 fprintf(file2,"</tr>\n\n");
					}
				 fprintf(file2,"</table><br>\n\n");
				 ii=jj=grandezza;
				 continue;
				}

			 if(passi[ii][jj]==gg+10000)
			 	{fprintf(file2,"</p><hr width=600 size=3 color=red><p align=center>");
				 fprintf(file2,"<br>%3d numero trovato (%d,%d): %2d (Numero imposto arbitrariamente)<br><br>\n",gg,ii+1,jj+1,tabella[ii][jj]);
			 	 tabellaold[ii][jj]=tabella[ii][jj];
				 fprintf(file2,"<TABLE border=1 cellpadding=5 align=center>\n\n");
				 colrcorr=-1;
				 for(aa=0;aa<grandezza;aa++)
				 	{if(aa%quad==0)
						colrcorr=(colrcorr+1)%2;
					 colccorr=colrcorr;
					 fprintf(file2,"<tr>\n\n");
					 for(bb=0;bb<grandezza;bb++)
				 		{if(bb%quad==0)
							colccorr=(colccorr+1)%2;
						 if(tabellaold[aa][bb]==0)
						 	if(colccorr==0)
							 	fprintf(file2,"<td>&nbsp;</td>\n");
							else
								fprintf(file2,"<td bgcolor=white>&nbsp;</td>\n");
						 else
						 	if(aa==ii && bb==jj)
						 		fprintf(file2,"<td bgcolor=red>%d</td>\n",tabellaold[aa][bb]);
						 	else
						 		if(colccorr==0)
								 	fprintf(file2,"<td>%d</td>\n",tabellaold[aa][bb]);
								else
									fprintf(file2,"<td bgcolor=white>%d</td>\n",tabellaold[aa][bb]);
						}
					 fprintf(file2,"</tr>\n\n");
					}
				 fprintf(file2,"</table><br>\n\n");
				 ii=jj=grandezza;
			 	 continue;
				}

			 if(passi[ii][jj]==gg+20000)
			 	{fprintf(file2,"<br>%3d numero trovato (%d,%d): %2d (Numero determinato univocamente - Unico possibile di riga)<br><br>\n",gg,ii+1,jj+1,tabella[ii][jj]);
			 	 tabellaold[ii][jj]=tabella[ii][jj];
				 fprintf(file2,"<TABLE border=1 cellpadding=5 align=center>\n\n");
				 colrcorr=-1;
				 for(aa=0;aa<grandezza;aa++)
				 	{if(aa%quad==0)
						colrcorr=(colrcorr+1)%2;
					 colccorr=colrcorr;
					 fprintf(file2,"<tr>\n\n");
					 for(bb=0;bb<grandezza;bb++)
				 		{if(bb%quad==0)
							colccorr=(colccorr+1)%2;
						 if(tabellaold[aa][bb]==0)
						 	if(colccorr==0)
							 	fprintf(file2,"<td>&nbsp;</td>\n");
							else
								fprintf(file2,"<td bgcolor=white>&nbsp;</td>\n");
						 else
						 	if(aa==ii && bb==jj)
						 		fprintf(file2,"<td bgcolor=red>%d</td>\n",tabellaold[aa][bb]);
						 	else
						 		if(colccorr==0)
								 	fprintf(file2,"<td>%d</td>\n",tabellaold[aa][bb]);
								else
									fprintf(file2,"<td bgcolor=white>%d</td>\n",tabellaold[aa][bb]);
						}
					 fprintf(file2,"</tr>\n\n");
					}
				 fprintf(file2,"</table><br>\n\n");
				 ii=jj=grandezza;
			 	 continue;
				}

			 if(passi[ii][jj]==gg+30000)
			 	{fprintf(file2,"<br>%3d numero trovato (%d,%d): %2d (Numero determinato univocamente - Unico possibile di colonna)<br><br>\n",gg,ii+1,jj+1,tabella[ii][jj]);
			 	 tabellaold[ii][jj]=tabella[ii][jj];
				 fprintf(file2,"<TABLE border=1 cellpadding=5 align=center>\n\n");
				 colrcorr=-1;
				 for(aa=0;aa<grandezza;aa++)
				 	{if(aa%quad==0)
						colrcorr=(colrcorr+1)%2;
					 colccorr=colrcorr;
					 fprintf(file2,"<tr>\n\n");
					 for(bb=0;bb<grandezza;bb++)
				 		{if(bb%quad==0)
							colccorr=(colccorr+1)%2;
						 if(tabellaold[aa][bb]==0)
						 	if(colccorr==0)
							 	fprintf(file2,"<td>&nbsp;</td>\n");
							else
								fprintf(file2,"<td bgcolor=white>&nbsp;</td>\n");
						 else
						 	if(aa==ii && bb==jj)
						 		fprintf(file2,"<td bgcolor=red>%d</td>\n",tabellaold[aa][bb]);
						 	else
						 		if(colccorr==0)
								 	fprintf(file2,"<td>%d</td>\n",tabellaold[aa][bb]);
								else
									fprintf(file2,"<td bgcolor=white>%d</td>\n",tabellaold[aa][bb]);
						}
					 fprintf(file2,"</tr>\n\n");
					}
				 fprintf(file2,"</table><br>\n\n");
				 ii=jj=grandezza;
			 	 continue;
				}

			 if(passi[ii][jj]==gg+40000)
			 	{fprintf(file2,"<br>%3d numero trovato (%d,%d): %2d (Numero determinato univocamente - Unico possibile del quadrato)<br><br>\n",gg,ii+1,jj+1,tabella[ii][jj]);
			 	 tabellaold[ii][jj]=tabella[ii][jj];
				 fprintf(file2,"<TABLE border=1 cellpadding=5 align=center>\n\n");
				 colrcorr=-1;
				 for(aa=0;aa<grandezza;aa++)
				 	{if(aa%quad==0)
						colrcorr=(colrcorr+1)%2;
					 colccorr=colrcorr;
					 fprintf(file2,"<tr>\n\n");
					 for(bb=0;bb<grandezza;bb++)
				 		{if(bb%quad==0)
							colccorr=(colccorr+1)%2;
						 if(tabellaold[aa][bb]==0)
						 	if(colccorr==0)
							 	fprintf(file2,"<td>&nbsp;</td>\n");
							else
								fprintf(file2,"<td bgcolor=white>&nbsp;</td>\n");
						 else
						 	if(aa==ii && bb==jj)
						 		fprintf(file2,"<td bgcolor=red>%d</td>\n",tabellaold[aa][bb]);
						 	else
						 		if(colccorr==0)
								 	fprintf(file2,"<td>%d</td>\n",tabellaold[aa][bb]);
								else
									fprintf(file2,"<td bgcolor=white>%d</td>\n",tabellaold[aa][bb]);
						}
					 fprintf(file2,"</tr>\n\n");
					}
				 fprintf(file2,"</table><br>\n\n");
				 ii=jj=grandezza;
			 	 continue;
				}

			}
		}
	}

fprintf(file2,"</p>\n");
fprintf(file2,"</body></html>\n");

fclose(file2);

}







